/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.availability;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailability;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.constants.EnumAvailabilityStackData;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.containers.ContainerAvailabilityInv;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.AvailabilityStackData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class SubGuiNpcAvailabilityItemStacks
extends GuiContainerNPCInterface
implements ICustomScrollListener {
    public static GuiScreen parent;
    public static SubGuiNpcAvailability setting;
    private final Availability availability;
    private final ContainerAvailabilityInv cont;
    private GuiCustomScroll scroll;
    private int reset = 0;

    public SubGuiNpcAvailabilityItemStacks(ContainerAvailabilityInv container) {
        super((EntityNPCInterface)null, (Container)container);
        this.setBackground("itemsetup.png");
        this.field_146999_f = 176;
        this.field_147000_g = 202;
        this.drawDefaultBackground = true;
        this.closeOnEsc = true;
        this.title = "Availability Stacks";
        this.availability = container.availability;
        this.cont = container;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        AvailabilityStackData aData = this.availability.stacksData.get(this.cont.slot.getSlotIndex());
        switch (button.getID()) {
            case 0: {
                aData.ignoreDamage = button.getValue() == 0;
                button.setHoverText("gui.ignoreDamage." + button.getValue(), new Object[0]);
                break;
            }
            case 1: {
                aData.ignoreNBT = button.getValue() == 0;
                button.setHoverText("gui.ignoreNBT." + button.getValue(), new Object[0]);
                break;
            }
            case 2: {
                aData.type = EnumAvailabilityStackData.values()[(aData.type.ordinal() + 1) % EnumAvailabilityStackData.values().length];
                button.setHoverText("availability.hover.stack.type." + aData.type.name().toLowerCase(), new Object[0]);
                this.func_73866_w_();
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.reset > 0) {
            --this.reset;
            if (this.reset == 0) {
                this.func_73866_w_();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_147003_i + 8;
        int y = this.field_147009_r + 3;
        GuiNpcButton button = new GuiNpcButton(66, this.field_147003_i + this.field_146999_f / 2 - 35, this.field_147009_r + 189, 70, 20, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        char c = '\u00a7';
        String select = "";
        for (int i = 0; i < this.cont.inv.func_70302_i_(); ++i) {
            String name;
            ItemStack stack = this.cont.inv.func_70301_a(i);
            AvailabilityStackData aData = this.availability.stacksData.get(i);
            if (stack.func_190926_b()) {
                name = Util.instance.deleteColor(new TextComponentTranslation("info.item.cloner.empty.0", new Object[0]).func_150254_d());
            } else {
                name = stack.func_82833_r();
                if (stack.func_190916_E() > 1) {
                    name = name + " x" + stack.func_190916_E();
                }
            }
            String suffix = aData.type == EnumAvailabilityStackData.Always ? c + "aA" : (aData.type == EnumAvailabilityStackData.Contains ? c + "bC" : c + "cE");
            String key = c + "7" + (i + 1) + ": " + c + "r" + name;
            list.add(key);
            stacks.add(stack);
            suffixes.add(suffix);
            if (i != this.cont.slot.getSlotIndex()) continue;
            select = key;
        }
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(102, 107);
        }
        this.scroll.setList(list);
        this.scroll.setStacks(stacks);
        this.scroll.setSuffixes(suffixes);
        this.scroll.guiLeft = this.field_147003_i + 70;
        this.scroll.guiTop = this.field_147009_r + 4;
        if (!select.isEmpty()) {
            this.scroll.setSelected(select);
        }
        this.addScroll(this.scroll);
        AvailabilityStackData aData = this.availability.stacksData.get(this.cont.slot.getSlotIndex());
        this.addLabel(new GuiNpcLabel(0, "gui.ignoreDamage", x, y + 2));
        button = new GuiNpcButton(0, x, y += 12, 50, 14, new String[]{"gui.yes", "gui.no"}, aData == null || aData.ignoreDamage ? 0 : 1);
        button.setHoverText("gui.ignoreDamage." + button.getValue(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(1, "gui.ignoreNBT", x, (y += 16) + 2));
        button = new GuiNpcButton(1, x, y += 12, 50, 14, new String[]{"gui.yes", "gui.no"}, aData == null || aData.ignoreNBT ? 0 : 1);
        button.setHoverText("gui.ignoreNBT." + button.getValue(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(2, "gui.type", x, (y += 16) + 2));
        button = new GuiNpcButton(2, x, y + 12, 50, 14, "availability." + (aData == null ? "always" : aData.type.name().toLowerCase()));
        button.setHoverText("availability.hover.stack.type." + (aData == null ? "always" : aData.type.name().toLowerCase()), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(3, "ID: " + this.cont.slot.getSlotIndex(), x + 20, this.field_147009_r + 87));
    }

    @Override
    public void close() {
        super.close();
        if (parent != null) {
            this.displayGuiScreen(parent);
        }
    }

    @Override
    public void save() {
        if (setting != null) {
            NBTTagCompound compound = new NBTTagCompound();
            this.availability.save(compound);
            SubGuiNpcAvailabilityItemStacks.setting.availability.load(compound);
        }
    }

    protected void func_184098_a(@Nonnull Slot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        if (slotIn == this.cont.slot) {
            this.reset = 3;
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.cont.slot.setSlotIndex(scroll.getSelect(), true);
        scroll.setSelect(this.cont.slot.getSlotIndex());
        Client.sendData(EnumPacketServer.AvailabilitySlot, this.cont.slot.getSlotIndex());
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
    }
}

